DROP PROCEDURE IF EXISTS sp_insertUpdateProducto;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateProducto`(IN p_idProducto INT, IN p_idClase INT, 
	IN p_codigo VARCHAR(10), IN p_codigoContable VARCHAR(8), IN p_nombre VARCHAR(50), IN p_marca VARCHAR(50), 
    IN p_modelo VARCHAR(50), IN p_medida VARCHAR(50), IN p_cod_fab VARCHAR(50), 
    IN p_talla VARCHAR(50), IN p_color VARCHAR(50), IN p_lineaNegocio VARCHAR(50), 
    IN p_stockMin DECIMAL(10,2), IN p_unidad_medida CHAR(5), IN p_tipo_existencia CHAR(5), 
    IN p_valorUnitario DECIMAL(18,6), IN p_igvUnitario DECIMAL(18,6), IN p_precioUnitario DECIMAL(18,6), 
    IN p_aplicaVenta BIT,
    IN p_registro_user_add VARCHAR(50), IN p_registro_user_update VARCHAR(50), IN p_activo INT, 
    IN p_tipoOperacion INT)
BEGIN  
	DECLARE contadorInsert int; 
    DECLARE contadorUpdate int;
    DECLARE correlativo int;
    DECLARE cod_clase varchar(50);
    DECLARE abrev_clase char(3);
    DECLARE v_unidadMedida char(5);
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM PRODUCTO WHERE nombre = p_nombre);
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			SET @correlativo = (SELECT COUNT(*) FROM PRODUCTO WHERE idClase = p_idClase);
            SET @correlativo = @correlativo + 1;
            
            SET @cod_clase = (SELECT codigo FROM CLASE WHERE idClase = p_idClase);
            
            
            SET p_codigoContable = (
								SELECT cast(codigoContable as UNSIGNED)  + 1 FROM PRODUCTO 
								WHERE substring(codigoContable, 1, 5) = @cod_clase
								ORDER BY codigoContable DESC LIMIT 1);			
            
            SET p_codigo = (	SELECT (CASE WHEN (cast(codigo as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 1000000 THEN  (CAST(codigo as UNSIGNED) + 1)
										END)
								FROM PRODUCTO 
								WHERE idClase = p_idClase
								ORDER BY codigo DESC LIMIT 1);
            
            IF p_codigoContable is null THEN
				SET p_codigoContable = (SELECT CONCAT(codigo, '01') FROM CLASE WHERE idClase = p_idClase);
            END IF;
            
            IF p_codigo is null THEN
				SET p_codigo = '000001';
            END IF;
            
			INSERT INTO PRODUCTO(
							idClase, codigo, codigoContable,
							nombre, marca, modelo, medida, cod_fab, talla, color, lineaNegocio,
                            stockMin, stockActual,
                            unidad_medida, tipo_existencia,
                            valor_unitario, igv_unitario, precio_unitario, aplicaVenta,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
			) 
			VALUES (	
						p_idClase, p_codigo, p_codigoContable,
						p_nombre, p_marca, p_modelo, p_medida, p_cod_fab, p_talla, p_color, p_lineaNegocio,
                        p_stockMin, 0.00,
                        p_unidad_medida, p_tipo_existencia,
						p_valorUnitario, p_igvUnitario, p_precioUnitario, p_aplicaVenta,
						now(), p_registro_user_add,  "-",
						now(), "-", "-", 1
			);           
            
            SELECT idProducto AS 'respuesta' FROM PRODUCTO ORDER BY idProducto DESC LIMIT 1;
            		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM PRODUCTO WHERE nombre = p_nombre and idProducto != p_idProducto);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			SET @contadorUpdate = (SELECT COUNT(*) FROM PRODUCTO WHERE codigo = p_codigo and idClase = p_idClase and idProducto != p_idProducto);
			IF (@contadorUpdate) > 0 THEN
				SELECT '-1' AS 'respuesta';
			ELSE
				set @v_unidadMedida = (SELECT unidad_medida FROM PRODUCTO WHERE idProducto = p_idProducto);
				IF EXISTS(SELECT idProducto FROM DETALLE_NOTA_ALMACEN 
					WHERE idProducto = p_idProducto) and @v_unidadMedida != p_unidad_medida then					
                    SELECT '-2' AS 'respuesta';					
				ELSE
					UPDATE PRODUCTO SET
						idClase = p_idClase, codigo = p_codigo,  codigoContable = p_codigoContable, 
						nombre = p_nombre, marca = p_marca,
						modelo = p_modelo, medida = p_medida, cod_fab = p_cod_fab,
						talla = p_talla, color = p_color, lineaNegocio = p_lineaNegocio,
						stockMin = p_stockMin,
						unidad_medida = p_unidad_medida,
						tipo_existencia = p_tipo_existencia,
						valor_unitario = p_valorUnitario, igv_unitario = p_igvUnitario, precio_unitario = p_precioUnitario, 
                        aplicaVenta = p_aplicaVenta,
						registro_fecha_update = now(),
						registro_user_update = p_registro_user_update, 
						registro_pc_update = '-',
						activo = p_activo
					WHERE idProducto = p_idProducto;	            
						   
					SELECT p_idProducto AS 'respuesta';
					
				END IF;
            END IF;
		END	IF;
	END IF;
END
$